// MFT GROUP Admin Dashboard Tab Management - Fixed Version
// This script handles tab switching functionality for the admin dashboard

console.log('=== ADMIN DASHBOARD TABS FIX LOADING ===');

// Global variables to track tab state
let currentTab = 'overview';
let tabListenerAttached = false;

// Wait for the DOM to be fully loaded
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM Content Loaded - Initializing admin dashboard tabs fix');
    initializeAdminTabs();
});

// Function to initialize admin dashboard tabs
function initializeAdminTabs() {
    console.log('Initializing admin dashboard tabs fix');
    
    // Initialize tabs
    initTabs();
    
    console.log('Admin dashboard tabs fix initialized');
}

// Function to initialize tab event listeners
function initTabs() {
    console.log('Initializing tab event listeners');
    
    if (tabListenerAttached) {
        console.log('Tab listeners already attached, skipping');
        return;
    }
    
    // Add click event listeners to all tab buttons
    const tabButtons = document.querySelectorAll('.tab-btn');
    console.log('Found', tabButtons.length, 'tab buttons');
    
    if (tabButtons.length === 0) {
        console.warn('No tab buttons found');
        return;
    }
    
    tabButtons.forEach(button => {
        // Remove any existing listeners to prevent duplicates
        button.removeEventListener('click', handleTabClick);
        
        // Add click event listener
        button.addEventListener('click', handleTabClick);
    });
    
    tabListenerAttached = true;
    console.log('Tab listeners attached successfully');
}

// Function to handle tab click events
function handleTabClick(e) {
    e.preventDefault();
    const tabName = this.getAttribute('data-tab');
    
    console.log('Tab button clicked:', tabName);
    showTab(tabName, this);
}

// Function to show a specific tab
function showTab(tabName, clickedButton) {
    console.log('Showing tab:', tabName);
    
    try {
        // Remove active class from all tab buttons
        const allTabButtons = document.querySelectorAll('.tab-btn');
        allTabButtons.forEach(button => {
            button.classList.remove('active');
        });
        
        // Add active class to the clicked tab button
        if (clickedButton) {
            clickedButton.classList.add('active');
        }
        
        // Also add active class to any other buttons with the same data-tab value
        const matchingButtons = document.querySelectorAll(`.tab-btn[data-tab="${tabName}"]`);
        matchingButtons.forEach(button => {
            button.classList.add('active');
        });
        
        // Show/hide tab content based on the tab name
        showTabContent(tabName);
        
        console.log('Tab switched successfully to:', tabName);
        
        // Update current tab
        currentTab = tabName;
        
    } catch (error) {
        console.error('Error showing tab:', tabName, error);
    }
}

// Function to show/hide tab content
function showTabContent(tabName) {
    console.log('Showing tab content for:', tabName);
    
    try {
        // Hide all tab content sections within tab-content-area
        const tabContentArea = document.querySelector('.tab-content-area');
        if (tabContentArea) {
            const allTabContents = tabContentArea.querySelectorAll('.tab-content');
            allTabContents.forEach(content => {
                content.classList.remove('active');
                content.style.display = 'none';
            });
            
            // Show the selected tab content
            const activeContent = tabContentArea.querySelector(`.tab-content[data-tab="${tabName}"]`);
            if (activeContent) {
                activeContent.classList.add('active');
                activeContent.style.display = 'block';
            } else {
                console.warn('No content found for tab:', tabName);
            }
        } else {
            console.warn('Tab content area not found');
        }
        
        console.log('Tab content updated for:', tabName);
    } catch (error) {
        console.error('Error showing tab content:', tabName, error);
    }
}

// Make functions available globally
window.showTab = showTab;
window.initTabs = initTabs;
window.initializeAdminTabs = initializeAdminTabs;

console.log('=== ADMIN DASHBOARD TABS FIX LOADED ===');