// Admin Dashboard Landing Page Realtime Functionality
document.addEventListener('DOMContentLoaded', function() {
    console.log('Admin Dashboard Landing JS Loaded');
    
    // Set up logout button
    const logoutBtn = document.getElementById('logout-btn');
    if (logoutBtn) {
        logoutBtn.addEventListener('click', handleLogout);
    }
    
    // Simulate initial data loading
    simulateInitialDataLoad();
});

// Handle logout
function handleLogout() {
    if (confirm('Are you sure you want to logout?')) {
        // Perform logout actions
        // Redirect to login page or home page
        window.location.href = 'index.html';
    }
}

// Simulate initial data loading
function simulateInitialDataLoad() {
    console.log('Loading initial financial data...');
    
    // In a real implementation, this would fetch data from the server
    // For now, we'll just log that it would happen
    setTimeout(() => {
        console.log('Financial data loaded successfully');
        // Update cards with real data in a real implementation
    }, 1000);
}

// Update a specific card with new data
function updateCard(cardSelector, newValue, newTrend) {
    const card = document.querySelector(cardSelector);
    if (card) {
        const amountElement = card.querySelector('.amount');
        const trendElement = card.querySelector('.trend');
        
        if (amountElement) {
            amountElement.textContent = newValue;
        }
        
        if (trendElement) {
            trendElement.innerHTML = newTrend;
        }
    }
}

// Format currency values
function formatCurrency(amount) {
    return 'KES ' + amount.toLocaleString();
}

// Update progress bar
function updateProgressBar(cardSelector, percentage) {
    const card = document.querySelector(cardSelector);
    if (card) {
        const progressBar = card.querySelector('.progress-fill');
        if (progressBar) {
            progressBar.style.width = percentage + '%';
        }
    }
}

console.log('Admin Dashboard Landing JS Initialized');