<?php
// Script to delete all test and debug files from the MFT project

echo "Starting cleanup of test and debug files...\n\n";

// List of test and debug files to delete
$filesToDelete = [
    // Test files
    'api/test.php',
    'create_and_approve_test_loan.php',
    'create_test_loan_web.php',
    'direct_loans_test.php',
    'final_test.php',
    'simple_loan_test.php',
    'simple_test.php',
    'test-loan-sync.html',
    'test_admin_api.php',
    'test_admin_loans.html',
    'test_admins_api.php',
    'test_agreement_generation.php',
    'test_api.html',
    'test_api_access.php',
    'test_api_update.php',
    'test_approve_loan.php',
    'test_banking.html',
    'test_banking_settings.php',
    'test_connection.php',
    'test_db_connection.php',
    'test_documents_api.html',
    'test_dompdf.php',
    'test_export.html',
    'test_loan_agreement_detailed.php',
    'test_loan_agreement_generation.php',
    'test_loan_approval_agreement_generation.php',
    'test_loan_approval_api.php',
    'test_loan_approval_final.php',
    'test_loan_approval_process.php',
    'test_loans_api.php',
    'test_loans_api_direct.php',
    'test_loans_endpoint.php',
    'test_member_exists.php',
    'test_member_project.php',
    'test_member_project_query.php',
    'test_officials_api.html',
    'test_officials_api.php',
    'test_officials_api_direct.php',
    'test_officials_direct.php',
    'test_officials_fix.html',
    'test_payment_schedule.php',
    'test_pdf_fix.php',
    'test_project_api.html',
    'test_settings_api.php',
    
    // Debug files
    'debug_approval_process.php',
    'debug_detailed.php',
    'debug_loan_agreement.php',
    
    // Check files (diagnostic scripts)
    'check_access_codes.php',
    'check_access_codes_table.php',
    'check_admins.php',
    'check_agreements.php',
    'check_all_files.php',
    'check_db_connection.php',
    'check_db_structure.php',
    'check_loans_data.php',
    'check_loans_structure.php',
    'check_loans_table.php',
    'check_member_projects_table.php',
    'check_members_table.php',
    'check_projects_table.php',
    'check_system_settings.php',
    'check_table_structure.php',
    
    // Test summary documentation
    'LOAN_APPROVAL_TEST_SUMMARY.md'
];

$deletedCount = 0;
$errorCount = 0;

foreach ($filesToDelete as $file) {
    $filePath = __DIR__ . '/' . $file;
    
    if (file_exists($filePath)) {
        if (unlink($filePath)) {
            echo "Deleted: $file\n";
            $deletedCount++;
        } else {
            echo "Error deleting: $file\n";
            $errorCount++;
        }
    } else {
        echo "Not found (skipping): $file\n";
    }
}

echo "\nCleanup complete!\n";
echo "Files deleted: $deletedCount\n";
echo "Errors: $errorCount\n";

?>
