<?php
// MFT GROUP Member Photo API
// This API provides member profile photo information

// Enable CORS for frontend access
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database configuration
require_once __DIR__ . '/../database/config.php';

try {
    // Check if request method is GET
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        exit;
    }
    
    // Check if member_id is provided
    if (!isset($_GET['member_id']) || empty($_GET['member_id'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Member ID is required']);
        exit;
    }
    
    $member_id = $_GET['member_id'];
    
    // Get member photo information from database
    $pdo = getDatabaseConnection();
    
    $sql = "SELECT profile_picture FROM members WHERE member_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$member_id]);
    $member = $stmt->fetch();
    
    if (!$member) {
        http_response_code(404);
        echo json_encode(['error' => 'Member not found']);
        exit;
    }
    
    // Check if profile photo exists
    if (!empty($member['profile_picture']) && file_exists(__DIR__ . '/../' . $member['profile_picture'])) {
        // Photo exists, return the URL
        $photo_url = $member['profile_picture'];
        
        // Make sure the URL is relative to the web root
        if (strpos($photo_url, 'Passport Photos/') === 0) {
            $photo_url = 'Passport Photos/' . basename($photo_url);
        }
        
        http_response_code(200);
        echo json_encode([
            'success' => true,
            'photo_url' => $photo_url,
            'member_id' => $member_id
        ]);
    } else {
        // No photo available
        http_response_code(200);
        echo json_encode([
            'success' => false,
            'message' => 'No photo available for this member',
            'member_id' => $member_id
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Internal server error: ' . $e->getMessage()]);
}
?>