<?php
require_once 'database/config.php';

try {
    $pdo = getDatabaseConnection();
    
    // Check if the column already exists
    $stmt = $pdo->query("SHOW COLUMNS FROM projects LIKE 'current_amount'");
    $columnExists = $stmt->fetch();
    
    if (!$columnExists) {
        // Add the column if it doesn't exist
        $pdo->exec("ALTER TABLE projects ADD COLUMN current_amount DECIMAL(15, 2) DEFAULT 0.00 AFTER share_price");
        echo "Column 'current_amount' added successfully to projects table.\n";
    } else {
        echo "Column 'current_amount' already exists in projects table.\n";
    }
    
    // Update existing projects to calculate current_amount based on member contributions
    $stmt = $pdo->query("SELECT id FROM projects");
    $projects = $stmt->fetchAll();
    
    foreach ($projects as $project) {
        $projectId = $project['id'];
        
        // Calculate total contributions for this project
        $stmt = $pdo->prepare("SELECT COALESCE(SUM(amount_contributed), 0) as total_contributions FROM member_projects WHERE project_id = ?");
        $stmt->execute([$projectId]);
        $result = $stmt->fetch();
        $totalContributions = $result['total_contributions'];
        
        // Update the project with the calculated current amount
        $updateStmt = $pdo->prepare("UPDATE projects SET current_amount = ? WHERE id = ?");
        $updateStmt->execute([$totalContributions, $projectId]);
        
        echo "Updated project ID $projectId with current amount: $totalContributions\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>